package examples.localserver;

import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Ответ за запрос подписания данных
 *
 * @author Yedil M.
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DocumentSignatureResponse")
public class DocumentSignatureResponse {

    @XmlElement
    @Documentation("Подписанные данные")
    private String signedData;

    @XmlElement
    @Documentation("Подпись")
    private String signature;

    @XmlElement
    @Documentation("X.509 сертификат")
    private String certificate;

    public DocumentSignatureResponse(){}

    public DocumentSignatureResponse(String signedData, String signature, String x509cert) {
        this.signedData = signedData;
        this.signature = signature;
        this.certificate = x509cert;
    }

    public String getSignedData() {
        return signedData;
    }

    public void setSignedData(String signedData) {
        this.signedData = signedData;
    }

    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getCertificate() {
        return certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }
}
